/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

static const char __idstring[] = "@(#)$Id: mx_hostname_to_nic_id.c,v 1.2 2005/06/29 00:23:16 eugene Exp $";

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <string.h>

#include "mx_auto_config.h"
#include "myriexpress.h"

mx_return_t mx_hostname_to_nic_id(char *hostname, uint64_t *nic_ids)
{

  struct hostent *host;
  uint32_t addr;

  int i;

  if ((hostname==NULL) || (nic_ids==NULL)){
    return MX_BAD_HOSTNAME_ARGS;
  }

  host = gethostbyname(hostname);

  if (host==NULL) {
    return MX_HOST_NOT_FOUND;
  }

  addr = *(uint32_t *)host->h_addr_list[0];
  nic_ids[0] = ntohl(addr);
  return MX_SUCCESS;
}
